//
// CThreadSwitchingClient.h
//
// Common base class for both ClientHandlers, implementing the thread-context switch
// to Genivi worker thread
//
//  Created on: Feb 26, 2015
//      Author: Martin Koch, Fa. ESE
//

#ifndef CTHREADSWITCHINGCLIENT_H_
#define CTHREADSWITCHINGCLIENT_H_


class CAmControlSenderBase;

#include "IAmControlReceiverShadow.h"
#include "../../../CCA_Node/interfaces/Node_if.h"

using namespace am;

class CThreadSwitchingClient : public FIMessaging::ITarget, private FIMessaging::IRxPollingThread
{
   private:
      FIMessaging::ServiceInfo m_ServiceInfo;
      FIMessaging::INode*      m_pMessagingNode;
      pid_t                    m_NativeThreadID;

   protected:
      am::IAmControlReceiverShadow& m_ControlReceiverShadow;
      FIMessaging::ISender* m_pSender;
      bool m_bSeviceAvailable;


      /* constructor */ CThreadSwitchingClient (tU16 serviceID, tFIVersionInfo serviceVersion, am::IAmControlReceiverShadow& receiverShadow);
      /* destructor */ ~CThreadSwitchingClient ();

      // Callback function for new messages invoked from Genivi Audiomanager thread
      //
      // Must be implemented in derived classes
      //
      virtual void vDispatchMessage (FIMessaging::FIMessage oMsg) = 0;
      virtual void vOnServiceAvailable (void) = 0;
      virtual void vOnServiceUnavailable (void) = 0;

   public:
      // - - - - - - - - - - - - - - - - - - - -
      //
      //      ITarget implementation

      // return ID and version of either provided or requested service
      virtual FIMessaging::ServiceInfo GetServiceInfo (void) const;

      // distinguish clients from services:
      virtual bool bProvidesService (void) const;

      // callback function to obtain message sender interface provided by Node
      virtual void vSetAssociatedSender (FIMessaging::ISender* pSender);

      // callback functions for incoming messages (called from CCA entry thread)
      virtual void vOnConnect (void);
      virtual void vOnDisconnect (void);
      virtual void vOnNewMessage (const FIMessaging::FIMessage& oMsg);

      // - - - - - - - - - - - - - - - - - - - -
      //
      //     IRxPollingThread implementation

      // switch context to Genivi worker thread, get and process message
      virtual void vRxNotificationCallback ();
};

#endif /* CTHREADSWITCHINGCLIENT_H_ */
